<?php
namespace VM\AdminBundle\Command;

use Doctrine\Bundle\DoctrineBundle\Registry;
use Doctrine\ORM\EntityManager;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use VM\ApiBundle\Entity\CompanyBankServiceOption;
use VM\ApiBundle\Entity\CompanyOfferReport;
use VM\ApiBundle\Entity\AccountChange;

class RepairCompanyOfferReportRoundsCommand extends ContainerAwareCommand
{
    private $Container;

    protected function configure()
    {
        $this
            ->setName('repair:reports:rounds')
            ->setDescription('Repair CompanyOfferReports Rounds - add round_ids')
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
//        $EntityManager = $this->getDoctrine();
        try
        {
            $this->runNativeSQLQuery("ALTER TABLE company_offer_reports ADD round_id INT;");
        }
        catch(\Exception $exception)
        {
            $output->writeln("Blad przygotowujacych SQLi: ".$exception->getMessage());
        }

        try
        {
            $this->runNativeSQLQuery("
                UPDATE
                company_offer_reports AS cor
                LEFT JOIN offer_reports AS ofr ON cor.report_id = ofr.id
                LEFT JOIN company AS c ON cor.company_id = c.id
                LEFT JOIN company_bank_service_options AS cbso ON (c.id = cbso.company_id AND cbso.option_id IN (1, 2))
                LEFT JOIN account_changes AS ac ON cbso.id = ac.company_bank_service_option_id
                SET cor.round_id = ac.round_id
                WHERE ac.description LIKE '%Raport%' AND ac.description LIKE CONCAT('%', ofr.name,'%');
            ");
        }
        catch(\Exception $exception)
        {
            $output->writeln("Blad przygotowujacych SQLi: ".$exception->getMessage());
        }

        try
        {
            $this->runNativeSQLQuery("ALTER TABLE company_offer_reports DROP PRIMARY KEY;");
        }
        catch(\Exception $exception)
        {
            $output->writeln("Blad przygotowujacych SQLi: ".$exception->getMessage());
        }

        try
        {
            $this->runNativeSQLQuery("ALTER TABLE company_offer_reports ADD id INT NOT NULL;");
        }
        catch(\Exception $exception)
        {
            $output->writeln("Blad przygotowujacych SQLi: ".$exception->getMessage());
        }


        try
        {
            $this->runNativeSQLQuery("ALTER TABLE company_offer_reports CHANGE round_id round_id INT NOT NULL;");
        }
        catch(\Exception $exception)
        {
            $output->writeln("Blad przygotowujacych SQLi: ".$exception->getMessage());
        }

        try
        {
            $this->runNativeSQLQuery("ALTER TABLE company_offer_reports CHANGE id id INT(11) AUTO_INCREMENT PRIMARY KEY; DESC company_offer_reports;");
        }
        catch(\Exception $exception)
        {
            $output->writeln("Blad przygotowujacych SQLi: ".$exception->getMessage());
        }

        try
        {
            $this->runNativeSQLQuery("ALTER TABLE company_offer_reports ADD CONSTRAINT FK_2C354331A6005CA0 FOREIGN KEY (round_id) REFERENCES rounds (id);");
        }
        catch(\Exception $exception)
        {
            $output->writeln("Blad konczacych SQLi: ".$exception->getMessage());
        }

        try
        {
            $this->runNativeSQLQuery("CREATE INDEX IDX_2C354331A6005CA0 ON company_offer_reports (round_id)");
        }
        catch(\Exception $exception)
        {
            $output->writeln("Blad konczacych SQLi: ".$exception->getMessage());
        }
        $output->writeln("Koniec.");
    }


    /**
     * @return EntityManager
     */
    protected function getDoctrine()
    {
        return $this->getContainer()->get('doctrine.orm.default_entity_manager');
    }

    protected function runNativeSQLQuery($query)
    {
        $stmt = $this->getDoctrine()
            ->getConnection()
            ->prepare($query);
        $stmt->execute();
    }
}